/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class FileWatch {
    private static final long INTERVAL = 10000L;
    private static Timer timer = new Timer(true);
    private static Vector files = new Vector();

    public static void addFile(File file, Observer observer) {
        for (int i = 0; i < files.size(); ++i) {
            FileObject f = (FileObject)files.get(i);
            if (!f.file.equals(file)) continue;
            f.addObserver(observer);
            return;
        }
        files.add(new FileObject(file, observer));
    }

    public static void removeFile(File file) {
        for (int i = 0; i < files.size(); ++i) {
            FileObject f = (FileObject)files.get(i);
            if (!f.file.equals(file)) continue;
            f.deleteObservers();
            files.remove(i);
        }
    }

    static {
        timer.schedule((TimerTask)new Worker(), 10000L, 10000L);
    }

    private static class Worker
    extends TimerTask {
        private Worker() {
        }

        @Override
        public void run() {
            for (int i = 0; i < files.size(); ++i) {
                ((FileObject)files.get(i)).check();
            }
        }
    }

    private static class FileObject
    extends Observable {
        private File file = null;
        private long lastModified = 0L;

        private FileObject(File file, Observer observer) {
            this.file = file;
            this.lastModified = file.lastModified();
            this.addObserver(observer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void check() {
            if (!this.file.exists()) {
                FileWatch.removeFile(this.file);
                this.setChanged();
                this.notifyObservers();
                return;
            }
            long newLastModified = this.file.lastModified();
            try {
                if (newLastModified != this.lastModified) {
                    this.setChanged();
                    this.notifyObservers(this.file);
                }
            }
            finally {
                this.lastModified = newLastModified;
            }
        }
    }
}

